
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "../../MachineInterface.h"
#include "../../auxbus/auxbus.h"

CMachineParameter const paraDummy = { pt_byte, "Dummy", "Dummy", 0, 127, 255, MPF_STATE, 0 };

CMachineParameter const *pParameters[] = 
{ 
	// global
	&paraDummy
};


#pragma pack(1)		

class gvals
{
public:
	byte dummy;
};


#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	0,										// flags
	0,										// min tracks
	0,										// max tracks
	1,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
#ifdef _DEBUG
	"Jeskola AuxSend (Debug build)",		// name
#else
	"Jeskola AuxSend",					// name
#endif
	"AuxSend",									// short name
	"Oskari Tammelin",						// author
	"Set Channel"
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);

	virtual void Command(int const i);
	virtual void Save(CMachineDataOutput * const po);

	void DisconnectAux();

private:
			
	

private:
	int Channel;

	
	gvals gval;

};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
}

mi::~mi()
{
	AB_Disconnect(this);
}

void cb(void *user)
{
	mi *pmi = (mi *)user;
	pmi->DisconnectAux();
}


#define VERSION		1

void mi::Init(CMachineDataInput * const pi)
{
	if (pi != NULL)
	{
		byte ver;
		pi->Read(ver);
		if (ver == VERSION)
		{
			pi->Read(Channel);
			
			if (Channel != -1)
				AB_ConnectInput(Channel, MacInfo.ShortName, cb, this);
		}
	
	}
	else
	{
		Channel = -1;
	}
}

void mi::Save(CMachineDataOutput * const po)
{
	po->Write((byte)VERSION);
	po->Write(Channel);
}


void mi::Tick()
{
}


bool mi::Work(float *psamples, int numsamples, int const mode)
{
	if (Channel != -1)
		AB_Send(Channel, (mode & WM_READ) ? psamples : NULL, numsamples);
	
	return false;
}



void mi::DisconnectAux()
{
	MACHINE_LOCK;

	Channel = -1;
}


void mi::Command(int const i)
{
	if (i == 0)
		AB_ShowEditor(&Channel, NULL, MacInfo.ShortName, cb, this);
}
